/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.capability.templates;

import cofh.lib.capability.CapabilityArchery;
import cofh.lib.capability.IArcheryBowItem;
import cofh.lib.util.helpers.ArcheryHelper;
import cofh.lib.util.helpers.MathHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class ArcheryBowItemWrapper
implements IArcheryBowItem,
ICapabilityProvider {
    private final LazyOptional<IArcheryBowItem> holder = LazyOptional.of(() -> this);
    private final float accuracyModifier;
    private final float damageModifier;
    private final float velocityModifier;
    final ItemStack bowItem;

    public ArcheryBowItemWrapper(ItemStack bowItem, float accuracyModifier, float damageModifier, float velocityModifier) {
        this.bowItem = bowItem;
        this.accuracyModifier = MathHelper.clamp(accuracyModifier, 0.1f, 10.0f);
        this.damageModifier = MathHelper.clamp(damageModifier, 0.1f, 10.0f);
        this.velocityModifier = MathHelper.clamp(velocityModifier, 0.1f, 10.0f);
    }

    public ArcheryBowItemWrapper(ItemStack bowItem) {
        this(bowItem, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public float getAccuracyModifier(Player shooter) {
        return this.accuracyModifier;
    }

    @Override
    public float getDamageModifier(Player shooter) {
        return this.damageModifier;
    }

    @Override
    public float getVelocityModifier(Player shooter) {
        return this.velocityModifier;
    }

    @Override
    public void onArrowLoosed(Player shooter) {
        this.bowItem.m_41622_(1, (LivingEntity)shooter, entity -> entity.m_21190_(shooter.m_7655_()));
    }

    @Override
    public boolean fireArrow(ItemStack arrow, Player shooter, int charge, Level world) {
        return ArcheryHelper.fireArrow(this.bowItem, arrow, shooter, charge, world);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityArchery.BOW_ITEM_CAPABILITY.orEmpty(cap, this.holder);
    }
}

